<?php
$config_data = require __DIR__ . '/config_lite.php';
$config = $config_data[ 'config' ];
$secret_key = $config[ 'secret_key' ];

function generate_token( $key ) {
   $token = bin2hex( random_bytes( 16 ) );
   $signature = hash_hmac( 'sha256', $token, $key );
   return [ 'token' => $token, 'signature' => $signature ];
}

$csrf = generate_token( $secret_key );
$form_id = bin2hex( random_bytes( 8 ) );

$now = time();

$image_dir = $config[ 'image_path' ] ?? '';

$expire_seconds = ( $config[ 'delete_after_minutes' ] ?? 3 ) * 60;

function is_hmac_named_file( $filename ) {
   return preg_match( '/^[a-f0-9]{16}_[a-f0-9]{64}\\.[a-z0-9]+$/', $filename );
}

if ( !( $config[ 'save_images' ] ?? false ) && is_dir( $image_dir ) ) {
   foreach ( glob( $image_dir . '*' ) as $file ) {
      $base = basename( $file );
      $mtime = filemtime( $file );
      $age = $now - $mtime;

      if ( is_hmac_named_file( $base ) ) {
         if ( $age > $expire_seconds ) {
            unlink( $file );
         }
      }
   }
}