<?php
if ( version_compare( PHP_VERSION, '7.0.0', '<' ) ) {
   die( 'このフォームは PHP 7.0.0 以上でのみ動作します。現在のバージョン: ' . PHP_VERSION );
}

// ------------------------------------------------------------
// メールフォーム設定ファイル（config_lite.php）2025/7/1
// ------------------------------------------------------------
return [
   'config' => [
      // ▼ メール送信設定
      'to_email' => '', //送信先メールアドレスを設定（1件のみ）
      'from_address' => '', //ドメイン入りの物を使用してください
      'require_fields' => [ 'お名前', 'email' ], //必須キーワード
      'secret_key' => '***ここに安全なランダム文字列を入力してください***', //例：5d8793aed96d808ab6af8e475ce244e8a604e478

      // ▼ プレビュー
      'enable_preview' => true, // プレビュー画面 true：あり/false：なし
      'use_images' => true, // 画像添付を許可するか

      // ▼ 画像添付設定
      'delete_after_minutes' => 3, // 画像の一時ファイル削除時間（分後）
      'max_image_size' => 2 * 1024 * 1024, // 画像1枚あたり最大サイズ（例：2MB）
      'save_images' => false, // false: 送信後削除
      'image_path' => __DIR__ . '/tmp/', // 画像保存先（サーバー内）
      'image_url' => './tmp/', // ブラウザ表示用URLパス


      // ▼ 自動返信
      'auto_reply_user' => true, // 【ユーザー】する/true しない/false
      'auto_reply_admin' => true, // 【管理者】する/true しない/false  
      'attach_images_to_user_mail' => false, // 【ユーザーに画像添付】する/true しない/false

      // ▼ 表示制御・ブロック
      'admin_mail_subject' => '【お問い合わせ】フォームからの送信テキスト', // 管理者あてメールの件名
      'admin_footer_note' => '※このメールは管理者用通知です', // 管理者あてメールのフッター文
      'user_mail_subject' => '【自動返信】お問い合わせありがとうございます', // 自動返信メールの件名
      'from_name' => 'お問い合わせ窓口', // 差出人名（Fromヘッダー用）
      'block_foreign_ip' => false, // 海外IPの簡易ブロック（true = 有効）
      'blocked_domains' => [ 'spam.com', 'temp-mail.org' ], // ブロックするドメイン一覧
      'ng_words' => [ 'セミナー', '副業', '集客','事業', '収益', '支援', 'SEO対策'], // NGワードによる投稿ブロック設定
      'ng_message' => 'Have a good day ☀',// NGワードが検出された場合に表示するメッセージ
      'redirect_url' => 'thanks.html', // 送信完了後のリダイレクト先
      'form_url' => '', // フォームの場所（未指定なら index.php）
      'recaptcha_secret' => '', //reCAPTCHA v2 シークレット キー
   ],
   'message' => [
      'return_header' => <<<EOD
{{onamae}} 様

この度は、お問い合わせいただきありがとうございます。
以下の内容で送信を受け付けました。
内容を確認の上、ご連絡いたしますのでしばらくお待ちくださいませ。

--------------------------------------------
■ ご入力内容
--------------------------------------------
EOD,

      'return_footer' => <<<EOD
────────────────────
このメールは自動返信です。内容にお心当たりがない場合は、
お手数ですが破棄してください。
────────────────────
EOD

   ]
];