<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<title>確認画面</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body {
   font-family: sans-serif;
   padding: 20px;
}
.data-group {
   margin-bottom: 15px;
}
img.preview {
   max-width: 200px;
   margin-right: 10px;
   margin-top: 10px;
}
.buttons {
   margin-top: 30px;
}
.error {
   color: red;
   margin-bottom: 20px;
   font-weight: bold;
}
.buttons {
   display: flex;
}
</style>
</head>
<body>
<h1>入力内容の確認</h1>
<?php if (!empty($errorMessages)): ?>
<div class="error-box">
   <ul>
      <?php foreach ($errorMessages as $msg): ?>
      <li>
         <?= htmlspecialchars($msg, ENT_QUOTES, 'UTF-8') ?>
      </li>
      <?php endforeach; ?>
   </ul>
</div>
<?php endif; ?>
<?php
// 表示除外したいキーのリスト
$excludedKeys = [ 'token', 'signature', 'hidden', 'hidden2', 'form_id', 'g-recaptcha-response' ];
?>
<?php foreach ($formFields as $key => $value): ?>
<?php if (in_array($key, $excludedKeys, true)) continue; // 除外リストにあるキーをスキップ ?>
<div class="data-group"> <strong>
   <?= h($key) ?>
   ：</strong>
   <?= is_array($value) ? h(implode(', ', $value)) : h($value) ?>
</div>
<?php endforeach; ?>
<?php if (!empty($savedImages)): ?>
<div class="data-group"> <strong>画像プレビュー：</strong><br>
   <?php foreach ($savedImages as $filename): ?>
   <img src="<?= h($config['image_url']) . h($filename) ?>" class="preview" alt="画像">
   <?php endforeach; ?>
</div>
<?php endif; ?>

<!-- データをsend.phpに送信するためのフォーム -->
<form action="send.php" method="post">
   <input type="hidden" name="form_id" value="<?= h($formFields['form_id'] ?? '') ?>">
   <?php foreach ($formFields as $key => $value): ?>
   <?php if (is_array($value)): ?>
   <?php foreach ($value as $v): ?>
   <input type="hidden" name="<?= h($key) ?>[]" value="<?= h($v) ?>">
   <?php endforeach; ?>
   <?php else: ?>
   <input type="hidden" name="<?= h($key) ?>" value="<?= h($value) ?>">
   <?php endif; ?>
   <?php endforeach; ?>
   
   <!-- 画像と動画情報を保持 -->
   <?php foreach ($savedImages as $filename): ?>
   <input type="hidden" name="uploaded_images[]" value="<?= h($filename) ?>">
   <?php endforeach; ?>
   
   <!-- ボタン -->
   <div class="buttons">
      <button type="submit">この内容で送信する</button>
   </div>
</form>
<form action="<?= htmlspecialchars($formUrl, ENT_QUOTES, 'UTF-8') ?>" method="post">
   <input type="hidden" name="form_id" value="<?= h($formFields['form_id'] ?? '') ?>">
   <input type="hidden" name="token" value="<?= htmlspecialchars($_POST['token'] ?? '') ?>">
   <input type="hidden" name="signature" value="<?= htmlspecialchars($_POST['signature'] ?? '') ?>">
   <div class="buttons">
      <button type="submit">戻って修正する</button>
   </div>
</form>
</body>
</html>
