<?php
define( 'FORM_DIR', realpath( __DIR__ . '/' ) );
require_once FORM_DIR . '/common.php';
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="default.css">
</head>
<body>
<form action="confirm.php" method="post" enctype="multipart/form-data">
   <input type="hidden" name="token" value="<?= htmlspecialchars($csrf['token']) ?>">
   <input type="hidden" name="signature" value="<?= htmlspecialchars($csrf['signature']) ?>">
   <input type="hidden" name="form_id" value="<?= htmlspecialchars($form_id) ?>">
   
   
   <div class="flex-layout">
      <div class="form-group">
         <label for="お名前" class="required">名前</label>
         <input type="text" name="お名前" id="お名前" placeholder="例: 檸檬" class="input-validation" required="">
      </div>
      <div class="form-group">
         <label for="ふりがな" class="required">ふりがな</label>
         <input type="text" name="ふりがな" id="ふりがな" placeholder="例: れもん" class="input-validation" required="">
      </div>
   </div>
   <div class="form-group">
      <label for="email" class="required">メールアドレス</label>
      <input type="email" name="email" id="email" placeholder="例: example@mail.com" class="input-validation" required="">
   </div>
   <div class="form-group">
      <label for="郵便番号">郵便番号</label>
      <input type="text" name="郵便番号" id="zipcode">
   </div>
   <div class="form-group">
      <label for="住所">住所</label>
      <input type="text" name="住所" id="address">
   </div>
   <div class="form-group">
      <label for="comment">フリーコメント</label>
      <textarea name="comment" id="message" class="input-validation" placeholder="ご自由に入力ください"></textarea>
   </div>
   <div class="form-group">
      <label for="img_src">ファイル</label>
      <input type="file" name="img_src" id="img_src">
   </div>
   <div class="form-group">
      <label for="img_src2">ファイル</label>
      <input type="file" name="img_src2" id="img_src2">
   </div>
   <div class="form-group">
      <label for="range">レンジ</label>
      <input type="range" name="range" id="range" min="0" max="100">
      <span class="range-value">0</span></div>
   <div class="checkbox-group">
      <input type="checkbox" name="check_box[]" value="項目1" id="check_box[]_0">
      <label for="check_box[]_0">項目1</label>
      <input type="checkbox" name="check_box[]" value="項目2" id="check_box[]_1">
      <label for="check_box[]_1">項目2</label>
      <input type="checkbox" name="check_box[]" value="項目3" id="check_box[]_2">
      <label for="check_box[]_2">項目3</label>
   </div>
   
   <!-- 最初の選択 -->
   <div class="form-group">
      <label>選択</label>
      <div class="radio-group" id="node1">
         <input type="radio" name="選択" value="項目1" id="選択_0" data-show="node2">
         <label for="選択_0">項目1</label>
         <input type="radio" name="選択" value="項目2" id="選択_1" data-show="node3">
         <label for="選択_1">項目2</label>
         <input type="radio" name="選択" value="項目3" id="選択_2" data-show="node4">
         <label for="選択_2">項目3</label>
      </div>
   </div>
   
   <!-- 選択2（項目1の結果） -->
   <div class="form-group" id="form-group-node2" style="display: none;">
      <label>選択2</label>
      <div class="radio-group" id="node2">
         <input type="radio" name="選択2" value="A" id="選択2_0">
         <label for="選択2_0">A</label>
         <input type="radio" name="選択2" value="B" id="選択2_1">
         <label for="選択2_1">B</label>
      </div>
   </div>
   
   <!-- 選択3（項目2の結果） -->
   <div class="form-group" id="form-group-node3" style="display: none;">
      <label>選択3</label>
      <div class="radio-group" id="node3">
         <input type="radio" name="選択3" value="B" id="選択3_0">
         <label for="選択3_0">B</label>
      </div>
   </div>
   
   <!-- 選択4（項目3の結果） -->
   <div class="form-group" id="form-group-node4" style="display: none;">
      <label>選択4</label>
      <div class="radio-group" id="node4">
         <input type="radio" name="選択4" value="C" id="選択4_0">
         <label for="選択4_0">C</label>
      </div>
   </div>
   <div id="privacyBox" style="height: 150px; overflow-y: scroll; border: 1px solid #ccc; padding: 1em; margin-bottom: 1em;">
      <p> こちらにプライバシーポリシーの長文が入ります。<br>
         ユーザーがスクロールすることで同意チェックが可能になります。<br>
         最後までスクロールすることで同意ボタンが有効化されます。<br>
         こちらにプライバシーポリシーの長文が入ります。<br>
         ユーザーがスクロールすることで同意チェックが可能になります。<br>
         最後までスクロールすることで同意ボタンが有効化されます。<br>
         こちらにプライバシーポリシーの長文が入ります。<br>
         ユーザーがスクロールすることで同意チェックが可能になります。<br>
         最後までスクロールすることで同意ボタンが有効化されます。<br>
         こちらにプライバシーポリシーの長文が入ります。<br>
         ユーザーがスクロールすることで同意チェックが可能になります。<br>
         最後までスクロールすることで同意ボタンが有効化されます。<br>
         こちらにプライバシーポリシーの長文が入ります。<br>
         ユーザーがスクロールすることで同意チェックが可能になります。<br>
         最後までスクロールすることで同意ボタンが有効化されます。<br>
         こちらにプライバシーポリシーの長文が入ります。<br>
         ユーザーがスクロールすることで同意チェックが可能になります。<br>
         最後までスクロールすることで同意ボタンが有効化されます。<br>
         こちらにプライバシーポリシーの長文が入ります。<br>
         ユーザーがスクロールすることで同意チェックが可能になります。<br>
         最後までスクロールすることで同意ボタンが有効化されます。<br>
      </p>
   </div>
   <div style="margin-bottom: 1em;">
      <label>
         <input type="checkbox" id="policyCheck">
         プライバシーポリシーに同意します </label>
   </div>
   <div class="form-group submit-group">
      <button type="submit" class="submit-button">送信する</button>
   </div>
   
   
</form>
<script>
/*プライバシーポリシーチェック*/
document.addEventListener('DOMContentLoaded', () => {
  const checkbox = document.getElementById('policyCheck');
  const submitBtn = document.querySelector('.submit-button');

  checkbox.addEventListener('change', () => {
    submitBtn.disabled = !checkbox.checked;
  });
  submitBtn.disabled = true;
});
</script> 
<script>
/*radioボタン連動*/
function setupRadioBranching() {
  const allRadios = document.querySelectorAll('input[type="radio"][data-show]');

  allRadios.forEach(radio => {
    radio.addEventListener('change', () => {
      allRadios.forEach(r => {
        const hideId = r.dataset.show;
        const hideElem = document.getElementById('form-group-' + hideId);
        if (hideElem) hideElem.style.display = 'none';
      });

      if (radio.checked) {
        const showId = radio.dataset.show;
        const showElem = document.getElementById('form-group-' + showId);
        if (showElem) showElem.style.display = 'block';
      }
    });
  });
}

function setupMutualExclusionGroup(names) {
  const nameToRadios = {};
  names.forEach(name => {
    nameToRadios[name] = document.querySelectorAll(`input[name="${name}"]`);
  });

  names.forEach(currentName => {
    nameToRadios[currentName].forEach(radio => {
      radio.addEventListener('change', () => {
        if (radio.checked) {
          names.forEach(otherName => {
            if (otherName !== currentName) {
              nameToRadios[otherName].forEach(r => r.checked = false);
            }
          });
        }
      });
    });
  });
}
setupRadioBranching();
setupMutualExclusionGroup(['選択2', '選択3', '選択4']);

</script> 
<script>
  /* trigger toggle*/
function initToggleVisibility() {
  const triggers = document.querySelectorAll('[data-toggle-target]');

  triggers.forEach(trigger => {
    const targetId = trigger.getAttribute('data-toggle-target');
    const targetElement = document.getElementById('form-group-' + targetId);

    if (targetElement) {
      targetElement.style.display = 'none'; 
    }

    const toggle = () => {
      let show = false;

      if (trigger.tagName.toLowerCase() === 'div' &&
          (trigger.classList.contains('radio-group') || trigger.classList.contains('checkbox-group'))) {
        trigger.querySelectorAll('input').forEach(input => {
          if (input.checked) show = true;
        });
      } else if (['checkbox', 'radio'].includes(trigger.type)) {
        show = trigger.checked;
      } else if (['text', 'email', 'tel', 'number', 'date', 'textarea'].includes(trigger.type) || 
                 trigger.tagName.toLowerCase() === 'select') {
        show = trigger.value.trim() !== '';
      } else if (trigger.type === 'file') {
        show = trigger.files.length > 0;
      } else if (trigger.type === 'range') {
        show = true;
      }

      if (targetElement) {
        targetElement.style.display = show ? 'block' : 'none';
        if (!show) hideDescendants(targetElement);
      }
    };

    const hideDescendants = (element) => {
      element.querySelectorAll('[data-toggle-target]').forEach(innerTrigger => {
        const innerTargetId = innerTrigger.getAttribute('data-toggle-target');
        const innerTarget = document.getElementById('form-group-' + innerTargetId);
        if (innerTarget) {
          innerTarget.style.display = 'none';
          hideDescendants(innerTarget);
        }
      });
    };

    toggle();

    if (trigger.tagName.toLowerCase() === 'div' &&
        (trigger.classList.contains('radio-group') || trigger.classList.contains('checkbox-group'))) {
      trigger.querySelectorAll('input').forEach(input => {
        input.addEventListener('change', toggle);
      });
    } else if (['checkbox', 'radio', 'select-one', 'file'].includes(trigger.type)) {
      trigger.addEventListener('change', toggle);
    } else {
      trigger.addEventListener('input', toggle);
    }
  });
}

document.addEventListener('DOMContentLoaded', function () {
  initToggleVisibility(); // 連動表示を初期化
});
</script> 
<script>
/*自動計算*/
function setupAutoCalculation() {
    const calcInputs = document.querySelectorAll('.auto-calc');
    calcInputs.forEach(input => {
        input.addEventListener('input', updateTotal);
    });
    updateTotal();
}

function updateTotal() {
    const calcInputs = document.querySelectorAll('.auto-calc');
    let total = 0;
    calcInputs.forEach(input => {
        const price = parseFloat(input.dataset.price || 0);
        const quantity = parseFloat(input.value || 0);
        total += price * quantity;
    });
    const totalField = document.getElementById('calc-total');
    if (totalField) {
        totalField.textContent = '¥' + total.toLocaleString();
    }
}
window.addEventListener('DOMContentLoaded', setupAutoCalculation);
</script>
<style>
  .validation-msg {color:#333333;    font-size: 0.9em; }
  .validation-msg.ok {    color: #4caf50;  }
  .validation-msg.ng {    color: #f44336;  }
</style>
<script>
/*validation*/
document.addEventListener('DOMContentLoaded', function () {
  const fields = document.querySelectorAll('.input-validation');

  fields.forEach(field => {
    const span = document.createElement('span');
    span.className = 'validation-msg';
    field.after(span);

    field.addEventListener('input', () => {
      let value = field.value.trim();
      let type = field.getAttribute('type') || field.tagName.toLowerCase();
      let isValid = false;

      // 判定ロジック
      if (type === 'email') {
        isValid = /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(value);
      } else if (type === 'tel') {
        isValid = /^[0-9\-]{9,15}$/.test(value);
      } else {
        isValid = value.length > 0;
      }

      // 表示更新
      if (value === '') {
        span.textContent = '';
        span.className = 'validation-msg';
      } else if (isValid) {
        span.textContent = 'OK';
        span.className = 'validation-msg ok';
      } else {
        span.textContent = '×';
        span.className = 'validation-msg ng';
      }
    });
  });
});
</script> 
<script>
function sanitizeInput(str) {
  return str
    .replace(/<script.*?>.*?<\/script>/gi, '【すくりぷと削除】')
    .replace(/script/gi, 'すくりぷと')
    .replace(/https?:\/\/[^\s]+/gi, '[リンク削除]')
    .replace(/javascript:/gi, '[js削除]');
}

document.addEventListener('DOMContentLoaded', function () {
  const textarea = document.getElementById('message');

  textarea.addEventListener('blur', function () {
    this.value = sanitizeInput(this.value);
  });
});

</script> 
<script>
/*住所入力サポート*/
document.getElementById('zipcode').addEventListener('blur', function () {
  const zip = this.value.replace(/[^0-9]/g, ''); // 数字のみ抽出（ハイフン削除）

  if (zip.length === 7) {
    fetch(`https://zipcloud.ibsnet.co.jp/api/search?zipcode=${zip}`)
      .then(response => response.json())
      .then(data => {
        if (data.results) {
          const result = data.results[0];
          const address = result.address1 + result.address2 + result.address3;
          document.getElementById('address').value = address;
        } else {
          document.getElementById('address').value = '住所が見つかりません';
        }
      })
      .catch(() => {
        document.getElementById('address').value = 'エラーが発生しました';
      });
  } else {
    document.getElementById('address').value = '';
  }
});
</script> 
<script>
      // レンジ表示
   function setupRangeValueDisplay() {
  document.querySelectorAll('input[type="range"]').forEach(range => {
    const span = range.closest('.form-group').querySelector('.range-value');
    if (span) {
      span.textContent = range.value;
      range.addEventListener('input', () => {
        span.textContent = range.value;
      });
    }
  });
}

document.addEventListener('DOMContentLoaded', () => {
  setupRangeValueDisplay();
});

   
</script> 
<script>
  // 画像・動画プレビュー
document.addEventListener('DOMContentLoaded', () => {

  document.querySelectorAll('input[type="file"]').forEach(input => {
    input.addEventListener('change', handleFilePreview);
  });
});

function handleFilePreview(event) {
    const file = event.target.files[0];
    if (!file) return;

    let previewWrapper = event.target.parentNode.querySelector('.previewWrapper');
    if (!previewWrapper) {
        previewWrapper = document.createElement('div');
        previewWrapper.className = 'previewWrapper';
        event.target.parentNode.appendChild(previewWrapper);
    }
    previewWrapper.innerHTML = '';

    // ファイル容量をMB単位で計算して表示
    const fileSizeMB = (file.size / (1024 * 1024)).toFixed(2);
    const sizeInfo = document.createElement('div');
    sizeInfo.textContent = 'ファイルサイズ: ' + fileSizeMB + ' MB';
    sizeInfo.style.fontSize = '0.9em';
    sizeInfo.style.marginTop = '5px';

    if (file.type.startsWith('image/')) {
        const img = document.createElement('img');
        img.src = URL.createObjectURL(file);
        img.width = 200;
        previewWrapper.appendChild(img);
    }

    // 容量表示
    previewWrapper.appendChild(sizeInfo);
}
</script>
</body>
</html>